;Keyboard Manager Scripts
;CopyRight 1997, 1999 by Henter-Joyce, Inc. 
;Created 5/15/97, cw
;Modified and updated 3/30/99 by DB
; Updated List View Speaking, DB
; Added functionality to automatically speak first two columns of Scripts list view
; not just with up and down arrows

include "jkey.jsm"
include "jkey.jsh"
include "hjglobal.jsh"
include "hjconst.jsh"

Void Function SayKeystroke ()
if (!IsPCCursor ()) then return endif
SaveCursor()
InvisibleCursor ()
RouteInvisibleToPc ()
NextChunk()
SayChunk ()
RestoreCursor()
EndFunction

Void Function SayHighlightedText (handle hWnd, string buffer)
var
	int iControl
If (GlobalMenuMode == 0) then
	If (IsPcCursor ()) then
		let iControl = GetControlID (hWnd)
		; stop extra chatter presented by custom handling of this list view
		If (iControl == ID_SCRIPT_LIST_VIEW) then
	SayChunk()
			SayKeystroke()
			Return
		EndIf
	EndIf
EndIf
SayHighlightedText (hWnd, buffer)
EndFunction

Void Function SayFocusedWindow ()
;wn1="Change Keystroke"
if ((GetWindowName (GetRealWindow (GetFocus ()))== wn1) 
&& (GetControlID(GetFocus()) == ID_CHANGE_KEYSTROKE_HOT_KEY)) then	
	Say (msg4, OT_MESSAGE) ;"Assign to hot key"
	return
endif
;wn2="Add Keystroke"
if ((GetWindowName (GetRealWindow (GetFocus ()))== wn2) 
&& (GetControlID(GetFocus()) == ID_ADD_KEYSTROKE_HOT_KEY)) then	
	Say (msg4, OT_MESSAGE) ;"Assign to hot key"
	return
endif
;wn3="Find Keystroke"
if ((GetWindowName (GetRealWindow (GetFocus ()))== wn3) 
&& (GetControlID(GetFocus()) == ID_FIND_KEYSTROKE_HOT_KEY)) then	
	Say (msg5, OT_MESSAGE) ;"hot key"
	return
endif
SayFocusedWindow ()
EndFunction

Script  ScriptFileName()
ScriptAndAppNames("Keyboard Manager")
EndScript

Script  SayBottomLineOfWindow()
if (GetControlID (GetFocus()) == 59649 && GlobalMenuMode == MENU_INACTIVE) then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (GetAppMainWindow (GetFocus ()))
	JAWSPageDown ()
	if (GetWindowClass(GetCurrentWindow()) != wcStatusBar) then
		Say (msg6, OT_MESSAGE) ;"cannot find synopsis window"
		Say (msg7, OT_MESSAGE) ;"make sure the status bar is turned on"
		Say (msg8, OT_MESSAGE) ;"the status bar can be toggled off or on through the view menu"
		return
	endif
	JAWSEnd ()
	SayChunk ()
else
	PerformScript SayBottomLineOfWindow()
endif
EndScript




